<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;
use MageQL\Type\FieldBuilder;

class Crossroads_CrossInvoice_Model_Graphql_Payment extends MageQL_Sales_Model_Payment_Abstract {
    public function getCode(): string {
        return "CrossInvoice";
    }

    public function getMethodTypeName(): string {
        return "CrossInvoice";
    }

    public function getPaymentMethodFields(Registry $registry): array {
        return [];
    }

    public function getQuotePaymentFields(Registry $registry): array {
        return [];
    }

    public function getMutateSetQuotePaymentFields(Registry $registry): array {
        return [
            "result" => $this->field(
                $this->getMutationResultType()."!",
                "Result of attempting to set the payment method to Collector Checkout"
            )
                // Simple result, we either succeed or fail
                ->setResolver("MageQL\\forwardResolver"),
        ];
    }

    public function mutateSetPaymentMethod(
        Mage_Sales_Model_Quote $quote,
        array $args,
        MageQL_Core_Model_Context $ctx,
        ResolveInfo $info
    ) {
        $model = Mage::getSingleton("mageql_sales/quote");
        $session = Mage::getSingleton("checkout/session");

        try {
            $model->importPaymentData($quote, "CrossInvoice", []);
            $model->saveSessionQuote();

            // Reset old session data in case we had a previous order
            $session->setLastOrderId(null);
            $session->setLastQuoteId(null);
            $session->setLastSuccessQuoteId(null);
            $session->setLastOrderId(null);
            $session->setLastRealOrderId(null);

            return self::SUCCESS;
        }
        catch(Mage_Core_Exception $e) {
            return $this->translatePaymentError($e);
        }
    }
}