<?php
/*
 * 2014-03-18   File created // JoLo
 *
 *
 * http://www.magentocommerce.com/wiki/5_-_modules_and_development/payment/create-payment-method-module
 * http://excellencemagentoblog.com/magento-create-custom-payment-method
 * Search for isInitializeNeeded() in /app/code/core for more info
 *
 * 2015-03-26   Removed utf8_encode for data from Visma // JoLo
 *
 * 2015-04-08   Reworked character encoding again // JoLo
 *
 */

class Crossroads_CrossInvoice_Model_PaymentMethod extends Mage_Payment_Model_Method_Abstract
{
    protected $_code = 'CrossInvoice'; // Important that this is the same as the module name under groups in system.xml

    protected $_isGateway                  = true;
    protected $_canOrder                   = true;
    protected $_canAuthorize               = true;
    protected $_canCapture                 = true;
    protected $_canCapturePartial          = false;
    protected $_canRefund                  = true;
    protected $_canRefundInvoicePartial    = false;
    protected $_canVoid                    = false;
    protected $_canUseInternal             = true;
    protected $_canUseCheckout             = true;
    protected $_canUseForMultishipping     = false;
    protected $_isInitializeNeeded         = false;
    protected $_canFetchTransactionInfo    = true;
    protected $_canReviewPayment           = false;
    protected $_canCreateBillingAgreement  = false;
    protected $_canManageRecurringProfiles = false;

    protected $_formBlockType = 'CrossInvoice/form';
    protected $_infoBlockType = 'CrossInvoice/info';

    protected function getVismaCustomerId($quote) {
        $customer = Mage::registry("current_customer");

        if(Mage::getSingleton('customer/session')->isLoggedIn()) {
            $customer = Mage::getSingleton('customer/session')->getCustomer();
        }

        if(!empty($customer) && $customer->getId()) {
            return $customer->getVismaCustomerId();
        }

        return null;
    }

    protected function getAddress($vismaCustomerId, $quote = null) {
        if($this->getConfigData("testmode", $quote ? $quote->getStoreId() : null)) {
            return [
                "company"   => "Test company",
                "postcode"  => "12345",
                "street1"   => "Paradisäppelvägen 111",
                "street2"   => "",
                "city"      => "Ankeborg",
                "telephone" => "0123456789",
                "country"   => "SE"
            ];
        }

        return Mage::helper("Integration")->getVismaAddressForVismaCustomerId($vismaCustomerId);
    }

    public function isAvailable($quote = null)
    {
        $checkResult = new StdClass;
        $checkResult->isAvailable = false;

        $activeInConfig = $this->getConfigData("active", $quote ? $quote->getStoreId() : null);
        if($activeInConfig && $this->getVismaCustomerId($quote)) {
            $checkResult->isAvailable = true;
        }

        $checkResult->isDeniedInConfig = !$checkResult->isAvailable; // for future use in observers

        Mage::dispatchEvent('payment_method_is_active', array(
            'result'          => $checkResult,
            'method_instance' => $this,
            'quote'           => $quote,
        ));

        // disable method if it cannot implement recurring profiles management and there are recurring items in quote
        if ($checkResult->isAvailable) {
            $implementsRecurring = $this->canManageRecurringProfiles();
            // the $quote->hasRecurringItems() causes big performance impact, thus it has to be called last
            if ($quote && !$implementsRecurring && $quote->hasRecurringItems()) {
                $checkResult->isAvailable = false;
            }
        }

        return $checkResult->isAvailable;
    }

    public function getVismaBillingAddress($vismaCustomerId = null, $quote = null)
    {
        if(empty($vismaCustomerId)) {
            $vismaCustomerId = $this->getVismaCustomerId($quote);
        }

        if(!empty($vismaCustomerId)) {
            return $this->getAddress($vismaCustomerId, $quote);
        }

        return false;
    }

    public function authorize(Varien_Object $payment, $amount)
    {
        Mage::helper("CrossInvoice")->log(LOG_DEBUG, __METHOD__, "called");
        parent::authorize($payment, $amount);

        $order = $payment->getOrder();
        $orderId = $order->getIncrementId();
        $debug = false;

        try {
            $vismaBillingAddress = $this->getVismaBillingAddress(null, $order->getQuote());
            if($vismaBillingAddress) {
                $billingAddress = $order->getBillingAddress();
                if($debug) {
                    Mage::helper("CrossInvoice")->log(LOG_DEBUG, __METHOD__, 'VismaBillingAddress: '.print_r($vismaBillingAddress, true));
                    $billingAddressDebug = $billingAddress->getData();
                    Mage::helper("CrossInvoice")->log(LOG_DEBUG, __METHOD__, 'MagentoAddressBefore: '.print_r($billingAddressDebug, true));
                }
                $billingAddress->setCompany($vismaBillingAddress['company'])
                    ->setPostcode($vismaBillingAddress['postcode'])
                    ->setStreet( empty($vismaBillingAddress['street2']) ? $vismaBillingAddress['street1'] : array($vismaBillingAddress['street1'], $vismaBillingAddress['street2']))
                    ->setCity($vismaBillingAddress['city'])
                    ->setTelephone($vismaBillingAddress['telephone'])
                    ->setCountry($vismaBillingAddress['country'])
                    ->save();
                $this->setStore($order->getStoreId());
                $payment->setStatus(self::STATUS_APPROVED);
                $payment->setAmount($amount);
                $payment->setLastTransId($orderId);
                if($debug) {
                    $billingAddressDebug = $order->getBillingAddress()->getData();
                    Mage::helper("CrossInvoice")->log(LOG_DEBUG, __METHOD__, 'MagentoAddressAfter: '.print_r($billingAddressDebug, true));
                }
            } else {
                Mage::throwException('Betalningen kan inte genomföras eftersom att det har blivit ett fel vid kontakten med vårt affärssystem. Vänligen kontakta kundtjänst så hjälper vi dig!');
            }

        } catch (Exception $e) {
            $this->setStore($order->getStoreId());
            $payment->setStatus(self::STATUS_ERROR);
            $payment->setAmount($amount);
            $payment->setLastTransId($orderId);

            throw $e;
        }

        return $this;
    }
}