<?php
/*
 * 2014-04-15   File created // JoLo
 *
 */

class Crossroads_CrossInvoice_Helper_Data extends Mage_Core_Helper_Abstract
{
    protected $_logFile = null;

    public function registerPayment(Varien_Event_Observer $observer) {
        $observer->getRegistry()->addMethod(new Crossroads_CrossInvoice_Model_ApiPayment());
    }

    public function checkoutPostMerge(Varien_Event_Observer $observer) {
        // We need to laod the billing address to make it pass validation
        $quote   = $observer->getQuote();
        $payment = $quote->getPayment();

        if( ! $payment || $payment->getMethod() !== "CrossInvoice") {
            return;
        }

        $method  = $payment->getMethodInstance();

        if( ! $method) {
            return;
        }

        $billing = $quote->getBillingAddress();
        $address = $method->getVismaBillingAddress();

        if( ! $address) {
            return;
        }

        $billing->setCompany($address['company'])
            ->setPostcode($address['postcode'])
            ->setStreet(empty($address['street2']) ? $address['street1'] : [$address['street1'], $address['street2']])
            ->setCity($address['city'])
            ->setTelephone($address['telephone'])
            ->setCountry($address['country'])
            ->save();
    }

    public function log($logType, $method, $message)
    {
        if(empty($this->_logFile)) {
            $this->_logFile = 'crossinvoice.'.date('Ymd').'.log';
        }
        // $logType: LOG_ERR, LOG_WARNING, LOG_DEBUG
        // $this->log(LOG_DEBUG, __METHOD__, "Message");
        Mage::log("{$method} {$message}", $logType, $this->_logFile, true);
    }

    public function logException($method, $exception, $messages = array())
    {
        foreach($messages as $message) {
            $this->log(LOG_ERR, $method, $message);
        }
        $this->log(LOG_ERR, $method, 'Message: '.$exception->getMessage());
        $this->log(LOG_ERR, $method, "Trace:\n".$exception->getTraceAsString());
    }

    public function getVismaCustomerId($customer = null)
    {
        if(empty($customer)) {
            if(Mage::getSingleton('customer/session')->isLoggedIn()) {
                $customer = Mage::getSingleton('customer/session')->getCustomer();
            }
        }
        $storeId = $customer->getStoreId();
    }

}
