
Requires a module named `Integration` with a `Data` helper containing the following method;

```php
/**
 * Fetches one billing address for a specific Visma customer id.
 *
 * The response has the following keys with UTF-8 string values:
 * 
 * * company
 * * postcode
 * * street1
 * * street2
 * * city
 * * telephone
 * * country    ISO 2-letter country code
 *
 * @param  integer
 * @return array|null
 */
public function getVismaAddressForVismaCustomerId($vismaCustomerId);
```

Customers need a `visma_customer_id` attribute, declaring which visma customer id will be used
for billing. If this is missing from a user the payment method will not be available. This module
will create such an attribute, accessible from the admin-interface.
