<?php

$installer = $this;
/* @var $installer Mage_Customer_Model_Entity_Setup */

$installer->startSetup();

$installer->addAttribute(
    'customer',
    'visma_customer_id',
    array(
        'group'                => 'Default',
        'type'                 => 'int',
        'label'                => 'Visma Customer ID',
        'input'                => 'text',
        'global'               => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'required'             => 0,
        'default'              => 0,
        'visible_on_front'     => 1,
        'used_for_price_rules' => 0,
        'adminhtml_only'       => 1,
    )
);

// We need to manually add the attribute here to be able to see it in admin
$attribute = Mage::getSingleton('eav/config')->getAttribute('customer', 'visma_customer_id');

$attribute->setData('used_in_forms', ['adminhtml_customer']);
$attribute->save();

$installer->endSetup();
