<?php
/*
 * 2014-03-18   File created // JoLo
 *
 */

class Crossroads_CrossInvoice_Model_Options_Orderstatus
{
    public function toOptionArray()
    {
        $aStatuses = Mage::getSingleton('sales/order_config')->getStates();
        $aOpts = array();
        $aOpts[] = array('value' => '', 'label' => Mage::helper('adminhtml')->__('-- Please Select --'));
        foreach($aStatuses as $sCode => $sLabel) {
            if($sCode != Mage_Sales_Model_Order::STATE_COMPLETE &&
               $sCode != Mage_Sales_Model_Order::STATE_CLOSED) {
                $aOpts[] = array('value' => $sCode, 'label' => $sLabel);
            }
        }
        return $aOpts;
    }

    public function toArray()
    {
        $aOpts = $this->toOptionArray();
        $aRet = array();
        foreach($aOpts as $aOption) {
            $aRet[$aOption['value']] = $aOption['label'];
        }
        return $aRet;
    }

}
?>
