<?php

class Crossroads_Collector_Model_Payment extends Crossroads_API_Payment_Abstract {
    public function getCode() {
        return "Crossroads_Collector";
    }

    public function getControllerClassName() {
        return "Crossroads_Collector_Controller_Payment";
    }

    public function getPaymentMethodData($quote) {
        $payment   = $quote->getPayment();
        $isCompany = $payment->getAdditionalInformation(Crossroads_Collector_Helper_Data::FIELD_IS_COMPANY);
        $ssn       = $payment->getAdditionalInformation(Crossroads_Collector_Helper_Data::FIELD_SSN);

        return [
            "socialSecurityNumber" => $ssn && is_string($ssn) && strlen($ssn) > 0 ? $ssn : null,
            "isCompany"            => is_null($isCompany) ? null : (boolean)$isCompany,
        ];
    }

    public function isQuoteInvalid($_quote) {
        return false;
    }

    public function getOrderPaymentData($_order) {
        return null;
    }
}
