<?php

class Crossroads_Collector_Controller_Payment extends Crossroads_API_Controller_Super {
    /**
     * @api {get} /payment/Crossroads_Collector/addresses
     * @apiName paymentCrossroads_Collector_getAddresses
     * @apiGroup Collector
     * @apiDescription Returns an array of addresses. If used with Crossroads_API, use this endpoint
     * instead of the endpoint available on /Crossroads_Collector/addresses.
     *
     * @apiParam {string} invId  The inhabitant id for the buyer
     *
     * @apiSuccess {String}   prefix
     * @apiSuccess {String}   firstname
     * @apiSuccess {String}   middlename
     * @apiSuccess {String}   lastname
     * @apiSuccess {String}   suffix
     * @apiSuccess {String}   company
     * @apiSuccess {String[]} street
     * @apiSuccess {String}   postcode
     * @apiSuccess {String}   city
     * @apiSuccess {String}   regionId
     * @apiSuccess {String}   countryId (SE, NO, DK)
     * @apiSuccess {String}   telephone
     * @apiSuccess {String}   fax
     */
    public function addressesAction() {
        if($this->getRequest()->getMethod() !== "GET") {
            return $this->sendData([405]);
        }

        $id = $this->getRequest()->getParam("invId");

        if( ! $id) {
            throw Crossroads_API_ResponseException::create(400, "Missing query parameter invId");
        }

        $store  = Mage::app()->getStore();
        $locale = Mage::app()->getLocale()->getLocaleCode();

        try {
            return $this->sendData([
                200,
                Mage::helper("Crossroads_Collector/soap")->fetchAddresses($store, $locale, $id)
            ]);
        }
        catch(Crossroads_Collector_Helper_Soap_Exception $e) {
            throw $e->asCrossroadsApiException();
        }
    }

    /**
     * @api {get} /payment/Crossroads_Collector/updateorderstate
     * @apiName paymentCrossroads_Collector_Updateorderstate
     * @apiGroup Collector
     * @apiDescription Callback endpoint for collector. If used with Crossroads_API, use this endpoint,
     * instead of the endpoint available on /Crossroads_Collector/updateorderstatus.
     */
    public function updateOrderStateAction() {
        Mage::helper("Crossroads_Collector")->handleOrderStatusUpdate($this->getRequest(), $this->getResponse());
    }
}
