<?php

/**
 * An exception which we can recover from if we use the fallback store.
 */
class Crossroads_Collector_Helper_Soap_RecoverableException extends Crossroads_Collector_Helper_Soap_Exception {
    public static function isRecoverableFaultcode($faultcode) {
        switch($faultcode) {
        case "s:DENIED_TO_PURCHASE":
        case "s:CREDIT_CHECK_DENIED":
        case "s:RESERVATION_NOT_APPROVED":
        case "s:PURCHASE_AMOUNT_GREATER_THAN_MAX_CREDIT_AMOUNT":
            return true;
        default:
            return false;
        }
    }

    public static function create(SoapFault $e) {
        list($_status, $_msg, $code) = self::faultcodeToResponse($e->faultcode);

        $newE = new Crossroads_Collector_Helper_Soap_RecoverableException(sprintf("Recoverable SoapFault: %s (%s): %s", $e->getMessage(), $e->faultcode, $e->faultstring), $code, $e);

        $newE->setFaultcode($e->faultcode);
        $newE->setFaultstring($e->faultstring);

        return $newE;
    }
}
