<?php

class Crossroads_Collector_Model_Payment extends Crossroads_API_Payment_Abstract {
    public function getCode() {
        return "Crossroads_Collector";
    }

    public function getControllerClassName() {
        return "Crossroads_Collector_Controller_Payment";
    }

    public function getPaymentMethodData($quote) {
        return [
            "socialSecurityNumber" => $quote->getPayment()->getAdditionalInformation(Crossroads_Collector_Helper_Data::FIELD_SSN)
        ];
    }

    public function isQuoteInvalid($_quote) {
        return false;
    }

    public function getOrderPaymentData($_order) {
        return null;
    }
}
