<?php

class Crossroads_Collector_Block_Info_Invoice extends Mage_Payment_Block_Info {
    protected function _prepareSpecificInformation($transport = null) {
        if($this->_paymentSpecificInformation) {
            return $this->_paymentSpecificInformation;
        }

        $helper  = Mage::helper("Crossroads_Collector");
        $payment = $this->getInfo();

        $transport = new Varien_Object();
        $transport = parent::_prepareSpecificInformation($transport);

        if(Mage::getDesign()->getArea() === "adminhtml") {
            $invoiceStatus = $payment->getAdditionalInformation(Crossroads_Collector_Helper_Data::FIELD_INVOICE_STATUS);

            $transport->addData([
                $helper->__("Invoice #")      => $payment->getAdditionalInformation(Crossroads_Collector_Helper_Data::FIELD_INVOICE_ID),
                $helper->__("Invoice status") => sprintf("%s (%d)", $this->invoiceStatusToHumanReadable($invoiceStatus), $invoiceStatus),
                $helper->__("Invoice OCR")    => $payment->getAdditionalInformation(Crossroads_Collector_Helper_Data::FIELD_PAYMENT_REFERENCE),
                $helper->__("Using fallback") => $payment->getAdditionalInformation(Crossroads_Collector_Helper_Data::FIELD_USING_FALLBACK) ? $helper->__("Yes") : $helper->__("No"),
                $helper->__("Store id")       => $payment->getAdditionalInformation(Crossroads_Collector_Helper_Data::FIELD_STORE_ID),
                $helper->__("Is Company")     => $payment->getAdditionalInformation(Crossroads_Collector_Helper_Data::FIELD_IS_COMPANY) ? $helper->__("Yes") : $helper->__("No"),
            ]);
        }

        return $transport;
    }

    protected function invoiceStatusToHumanReadable($invoiceStatus) {
        $helper = Mage::helper("Crossroads_Collector");

        switch($invoiceStatus) {
        case Crossroads_Collector_Helper_Data::INVOICE_STATUS_ON_HOLD:
            return $helper->__("On hold");
        case Crossroads_Collector_Helper_Data::INVOICE_STATUS_PRELIMINARY:
            return $helper->__("Preliminary");
        case Crossroads_Collector_Helper_Data::INVOICE_STATUS_ACTIVATED:
            return $helper->__("Activated");
        case Crossroads_Collector_Helper_Data::INVOICE_STATUS_REJECTED:
            return $helper->__("Rejected");
        case Crossroads_Collector_Helper_Data::INVOICE_STATUS_SIGNING:
            return $helper->__("Signing");
        default:
            return $helper->__("Unknown");
        }
    }
}
