<?php

class Crossroads_CollectorCheckout_Helper_Data extends Mage_Core_Helper_Abstract
{
    /**
     * @param string|int $reservedOrderId
     * @return ?Mage_Sales_Model_Quote
     */
    public function loadQuoteWithReservedId($reservedOrderId)
    {
        $quote = Mage::getModel('sales/quote')->load($reservedOrderId, 'reserved_order_id');

        return $quote->getId() ? $quote : null;
    }

    /**
     * @param string $incrementId
     * @return ?Mage_Sales_Model_Order
     */
    public function loadOrderByIncrementId($incrementId)
    {
        $quote = Mage::getModel('sales/order')->load($incrementId, 'increment_id');

        return $quote->getId() ? $quote : null;
    }
}
