<?php

namespace CollectorCheckoutTest;

use Mockery\Adapter\Phpunit\MockeryPHPUnitIntegration;
use PHPUnit\Framework\TestCase;

abstract class CollectorTestCase extends TestCase
{
    use MockeryPHPUnitIntegration;

    /**
     * @param string $path
     * @return mixed
     */
    protected function loadJSONFile($path)
    {
        return json_decode(file_get_contents($path));
    }

    /**
     * @param string $key
     * @param string $class
     * @return \Mockery\MockInterface|\Varien_Object
     */
    public function mockHelper($key, $class)
    {
        $mock = \Mockery::mock($class);

        \Mage::_setHelper($key, $mock);

        return $mock;
    }

    /**
     * @param string $key
     * @param string $class
     * @return \Mockery\MockInterface|\Varien_Object
     */
    protected function mockModel($key, $class)
    {
        $mock = \Mockery::mock($class);

        \Mage::_setModel($key, $mock);

        return $mock;
    }
}
