<?php

class Crossroads_CollectorCheckout_Model_Observer {
    public function onMageqlContextCreateAfter() {
        $session = Mage::getSingleton("checkout/session");
        $orderId = $session->getLastOrderId();
        $quoteId = $session->getQuoteId();

        if($orderId || ! $quoteId) {
            // We have an order
            return;
        }

        $order = Mage::getModel("sales/order");
        $quote = Mage::getModel("sales/quote");

        // We load this separately here to not trigger any checkout logic which
        // would populate fields:
        $quote->setStoreId(Mage::app()->getStore()->getId());
        $quote->load($quoteId);

        if( ! $quote->getId() ||
            $quote->getIsActive() ||
            ! $quote->getReservedOrderId() ||
            $quote->getPayment()->getMethod() !== "Crossroads_CollectorCheckout") {
            return;
        }

        $order->loadByIncrementId($quote->getReservedOrderId());

        if( ! $order->getId()) {
            return;
        }

        // We have to clear the session before saving the new order id, to make
        // sure it is not in conflict
        $session->clear();
        $session->setLastSuccessQuoteId($quote->getId());
        $session->setLastOrderId($order->getId());
        $session->setLastRealOrderId($order->getIncrementId());
    }
}
