<?php

class Crossroads_CollectorCheckout_Helper_Checkout_ApiClient extends Mage_Core_Helper_Abstract
{
    /**
     * @return Crossroads_CollectorCheckout_Helper_Config
     */
    protected function config()
    {
        return Mage::helper('Crossroads_CollectorCheckout/config');
    }

    /**
     * @param string $uri Without slash prefix
     * @param array $params
     * @return mixed
     * @throws Exception
     */
    public function get($uri, $params = [])
    {
        if ($params) {
            $uri .= '?'.http_build_query($params);
        }

        try {
            return $this->request('GET', $uri);
        } catch (Zend_Http_Client_Exception $exception) {
            throw Crossroads_API_ResponseException::create(500, $exception->getMessage(), null, $exception);
        }
    }

    /**
     * @param string $uri Without slash prefix
     * @param array $body
     * @return mixed
     * @throws Exception
     */
    public function post($uri, $body = [])
    {
        try {
            return $this->request('POST', $uri, $body);
        } catch (Zend_Http_Client_Exception $exception) {
            throw Crossroads_API_ResponseException::create(500, $exception->getMessage(), null, $exception);
        }
    }

    /**
     * @param string $uri Without slash prefix
     * @param array $body
     * @return mixed
     * @throws Exception
     */
    public function put($uri, $body = [])
    {
        try {
            return $this->request('PUT', $uri, $body);
        } catch (Zend_Http_Client_Exception $exception) {
            throw Crossroads_API_ResponseException::create(500, $exception->getMessage(), null, $exception);
        }
    }

    /**
     * @param string $method
     * @param string $uri
     * @param array $body
     * @return mixed
     * @throws Zend_Http_Client_Exception
     * @throws Exception
     */
    protected function request($method, $uri, $body = [])
    {
        $client = new Zend_Http_Client();

        $payload = '';

        $client->setUri($this->config()->backendApiUrl().'/'.$uri)
            ->setMethod($method)
            ->setConfig([
                'maxredirects' => 0,
                'timeout'      => 30,
            ]);

        if (in_array($method, ['PUT', 'POST'])) {
            $payload = json_encode($body);
            $client->setHeaders('Content-Length', strlen($payload));
            $client->setRawData($payload, 'application/json');
        }

        $client->setHeaders('Authorization', $this->authorizationHeader('/'.$uri, $payload));

        $response = $client->request();

        if (!$response->isSuccessful()) {
            throw Crossroads_API_ResponseException::create(
                $response->getStatus(),
                'Bad response from collector '.$response->getStatus(),
                json_decode($response->getBody()) ?: $response->getBody()
            );
        }

        return json_decode($response->getBody());
    }

    /**
     * @param string $path
     * @param string $payload
     * @return string
     */
    private function authorizationHeader($path, $payload)
    {
        $username = $this->config()->userName();
        $sharedAccessKey = $this->config()->sharedAccessKey();

        return 'SharedKey '.base64_encode($username.':'.hash('sha256', $payload.$path.$sharedAccessKey));
    }
}
