<?php

class Crossroads_CollectorCheckout_Helper_ConvertQuote extends Mage_Core_Helper_Abstract
{
    /**
     * @param Mage_Sales_Model_Quote $quote
     * @return Mage_Sales_Model_Order
     * @throws MageQL_Sales_SubmitQuoteException
     * @throws Exception
     */
    public function convert($quote)
    {
        $useGqlModule = Mage::helper('core')->isModuleEnabled('MageQL_Sales');

        if ($useGqlModule) {
            return Mage::helper("mageql_sales/quote")->submitOrder($quote);
        }

        $quote->collectTotals();

        $service = Mage::getModel('sales/service_quote', $quote);
        $service->submitAll();

        $quote->save(); // Save “is inactive”

        return $service->getOrder();
    }
}
