<?php

class Crossroads_CollectorCheckout_Helper_Config extends Mage_Core_Helper_Abstract
{
    const PREFIX = 'payment/Crossroads_CollectorCheckout';
    const PARENT_PREFIX = 'payment/Crossroads_Collector';

    /**
     * @param null|int $storeId
     * @return bool
     */
    public function active($storeId = null)
    {
        return 1 === (int) Mage::getStoreConfig(static::PREFIX.'/active', $storeId);
    }

    /**
     * @param null|int $storeId
     * @return string
     */
    public function title($storeId = null)
    {
        return (string) Mage::getStoreConfig(static::PREFIX.'/title', $storeId);
    }

    /**
     * @param null|int $storeId
     * @return int
     */
    public function merchantStoreId($storeId = null)
    {
        return (int) Mage::getStoreConfig(static::PREFIX.'/merchant_store_id', $storeId);
    }

    /**
     * @param null|int $storeId
     * @return bool
     */
    public function alwaysUseDigital($storeId = null)
    {
        return 1 === (int) Mage::getStoreConfig(static::PREFIX.'/always_use_digital', $storeId);
    }

    /**
     * @param null|int $storeId
     * @return string
     */
    public function countryCode($storeId = null)
    {
        return (string) Mage::getStoreConfig(static::PREFIX.'/country_code', $storeId);
    }

    /**
     * @param null|int $storeId
     * @return string
     */
    public function orderStatus($storeId = null)
    {
        return (string) Mage::getStoreConfig(static::PREFIX.'/order_status', $storeId);
    }

    /**
     * @param null|int $storeId
     * @return float
     */
    public function isTest($storeId = null)
    {
        return 1 === (int) Mage::getStoreConfig(static::PREFIX.'/is_test', $storeId);
    }

    /**
     * @return string
     */
    public function backendApiUrl()
    {
        return $this->isTest()
            ? 'https://checkout-api-uat.collector.se'
            : 'https://checkout-api.collector.se';
    }

    /**
     * @param null|int $storeId
     * @return string
     */
    public function userName($storeId = null)
    {
        return (string) Mage::getStoreConfig(static::PARENT_PREFIX.'/username', $storeId);
    }

    /**
     * @param null|int $storeId
     * @return string
     */
    public function sharedAccessKey($storeId = null)
    {
        return (string) Mage::getStoreConfig(static::PARENT_PREFIX.'/password', $storeId);
    }

    /**
     * @param null|int $storeId
     * @return float
     */
    public function minOrderTotal($storeId = null)
    {
        return (float) Mage::getStoreConfig(static::PREFIX.'/min_order_total', $storeId);
    }

    /**
     * @return string
     */
    public function getCallbackUrl()
    {
        // If using test setup and site is served through ngrok proxy.
        if ($this->isTest()) {
            $host = $_SERVER['HTTP_HOST'];

            // Host ends with...
            if ('.ngrok.io' === substr($host, -strlen('.ngrok.io'))) {
                return 'https://'.$host;
            }
        }

        return Mage::getBaseUrl();
    }

    /**
     * @param  null|int $storeId
     * @return string
     */
    public function termsUri($storeId = null)
    {
        return (string) Mage::getStoreConfig(static::PREFIX.'/terms_url', $storeId);
    }
}
