<?php

class Crossroads_CollectorCheckout_Helper_Config extends Mage_Core_Helper_Abstract
{
    const CONFIG_VIRTUAL_PROFILE = "payment/Crossroads_CollectorCheckout/profile_virtual";
    const CONFIG_DEFAULT_PROFILE = "payment/Crossroads_CollectorCheckout/profile_default";
    const CONFIG_UPDATE_ADDRESSES_FROM_COLLECTOR = "payment/Crossroads_CollectorCheckout/update_address_from_collector";
    const PREFIX = 'payment/Crossroads_CollectorCheckout';
    const PARENT_PREFIX = 'payment/Crossroads_Collector';

    public function getVirtualProfile(Mage_Core_Model_Store $store): string {
        return (string)$store->getConfig(self::CONFIG_VIRTUAL_PROFILE);
    }

    public function getDefaultProfile(Mage_Core_Model_Store $store): ?string {
        $val = trim((string)$store->getConfig(self::CONFIG_DEFAULT_PROFILE));

        return empty($val) ? null : $val;
    }

    public function active(Mage_Core_Model_Store $store): bool {
        return 1 === (int) $store->getConfig(static::PREFIX.'/active');
    }

    public function title(Mage_Core_Model_Store $store): string {
        return (string) $store->getConfig(static::PREFIX.'/title');
    }

    public function merchantStoreId(Mage_Core_Model_Store $store): int {
        return (int) $store->getConfig(static::PREFIX.'/merchant_store_id');
    }

    public function countryCode(Mage_Core_Model_Store $store): string {
        return (string) $store->getConfig(static::PREFIX.'/country_code');
    }

    public function orderStatus(Mage_Core_Model_Store $store): string {
        return (string) $store->getConfig(static::PREFIX.'/order_status');
    }

    public function isTest(Mage_Core_Model_Store $store): bool {
        return 1 === (int) $store->getConfig(static::PREFIX.'/is_test');
    }

    public function backendApiUrl(Mage_Core_Model_Store $store): string {
        return $this->isTest($store)
            ? 'https://checkout-api-uat.collector.se'
            : 'https://checkout-api.collector.se';
    }

    public function userName(Mage_Core_Model_Store $store): string {
        return (string) $store->getConfig(static::PARENT_PREFIX.'/username');
    }

    public function sharedAccessKey(Mage_Core_Model_Store $store): string {
        return (string) $store->getConfig(static::PARENT_PREFIX.'/password');
    }

    public function minOrderTotal(Mage_Core_Model_Store $store): float {
        return (float) $store->getConfig(static::PREFIX.'/min_order_total');
    }

    /**
     * @param string $path
     */
    public function getCallbackUrl(Mage_Core_Model_Store $store, $path): string {
        // If using test setup and site is served through ngrok proxy.
        if ($this->isTest($store)) {
            $host = $_SERVER['HTTP_HOST'];

            // Host ends with...
            if ('.ngrok.io' === substr($host, -strlen('.ngrok.io'))) {
                return 'https://'.$host.$path;
            }
        }

        return $store->getUrl($path, [
            '_nosid' => true,
        ]);
    }

    public function termsUri(Mage_Core_Model_Store $store): string {
        return (string) $store->getConfig(static::PREFIX.'/terms_url');
    }

    public function updateAddressesFromCollector(Mage_Core_Model_Store $store): bool {
        return (bool) $store->getConfig(self::CONFIG_UPDATE_ADDRESSES_FROM_COLLECTOR);
    }
}
