<?php

class Crossroads_CollectorCheckout_Helper_Data extends Mage_Core_Helper_Abstract
{
    /** @const string */
    private const LOG_CHANNEL = 'collector-checkout.log';

    /**
     * @param string|int $reservedOrderId
     * @return ?Mage_Sales_Model_Quote
     */
    public function loadQuoteWithReservedId($reservedOrderId)
    {
        $quote = Mage::getModel('sales/quote')->load($reservedOrderId, 'reserved_order_id');

        return $quote->getId() ? $quote : null;
    }

    /**
     * @param string $incrementId
     * @return ?Mage_Sales_Model_Order
     */
    public function loadOrderByIncrementId($incrementId)
    {
        $quote = Mage::getModel('sales/order')->load($incrementId, 'increment_id');

        return $quote->getId() ? $quote : null;
    }

    /**
     * Write to log.
     * @param string $message Message to log.
     * @param string $level Any Zend_Log level constant.
     */
    public function log(string $message, string $level = Zend_Log::DEBUG): void
    {
        Mage::log($message, $level, self::LOG_CHANNEL);
    }
}
