<?php

class Crossroads_CollectorCheckout_Helper_Checkout_ApiClient extends Mage_Core_Helper_Abstract
{
    /**
     * @return Crossroads_CollectorCheckout_Helper_Config
     */
    protected function config()
    {
        return Mage::helper('Crossroads_CollectorCheckout/config');
    }

    /**
     * @param string $uri Without slash prefix
     * @param array $params
     * @return mixed
     * @throws Exception
     */
    public function get(Mage_Core_Model_Store $store, $uri, $params = [])
    {
        if ($params) {
            $uri .= '?'.http_build_query($params);
        }

        try {
            return $this->request($store, 'GET', $uri);
        } catch (Zend_Http_Client_Exception $exception) {
            throw Crossroads_API_ResponseException::create(500, $exception->getMessage(), null, $exception);
        }
    }

    /**
     * @param string $uri Without slash prefix
     * @param array $body
     * @return mixed
     * @throws Exception
     */
    public function post(Mage_Core_Model_Store $store, $uri, $body = [])
    {
        try {
            return $this->request($store, 'POST', $uri, $body);
        } catch (Zend_Http_Client_Exception $exception) {
            throw Crossroads_API_ResponseException::create(500, $exception->getMessage(), null, $exception);
        }
    }

    /**
     * @param string $uri Without slash prefix
     * @param array $body
     * @return mixed
     * @throws Exception
     */
    public function put(Mage_Core_Model_Store $store, $uri, $body = [])
    {
        try {
            return $this->request($store, 'PUT', $uri, $body);
        } catch (Zend_Http_Client_Exception $exception) {
            throw Crossroads_API_ResponseException::create(500, $exception->getMessage(), null, $exception);
        }
    }

    /**
     * @param string $method
     * @param string $uri
     * @param array $body
     * @return mixed
     * @throws Zend_Http_Client_Exception
     * @throws Exception
     */
    protected function request(Mage_Core_Model_Store $store, $method, $uri, $body = [])
    {
        $client = new Zend_Http_Client();

        $payload = '';

        $client->setUri($this->config()->backendApiUrl($store).'/'.$uri)
            ->setMethod($method)
            ->setConfig([
                'maxredirects' => 0,
                'timeout'      => 30,
            ]);

        if (in_array($method, ['PUT', 'POST'])) {
            $payload = json_encode($body, JSON_UNESCAPED_SLASHES);
            $client->setHeaders('Content-Length', strlen($payload));
            $client->setRawData($payload, 'application/json');
        }

        $client->setHeaders('Authorization', $this->authorizationHeader($store, '/'.$uri, $payload));

        $response = $client->request();

        if (!$response->isSuccessful()) {
            throw new Exception(sprintf(
                "%s: %s %s (%s): %d %s",
                __CLASS__,
                $method,
                $uri,
                $payload,
                $response->getStatus(),
                $response->getBody()
            ));
        }
        else {
            Mage::log(sprintf(
                "%s: %s %s (%s): %d %s",
                __CLASS__,
                $method,
                $uri,
                $payload,
                $response->getStatus(),
                $response->getBody()
            ), Zend_Log::DEBUG, "collector-checkout.log");
        }

        return json_decode($response->getBody());
    }

    /**
     * @param string $path
     * @param string $payload
     * @return string
     */
    private function authorizationHeader(Mage_Core_Model_Store $store, $path, $payload)
    {
        $username = $this->config()->userName($store);
        $sharedAccessKey = $this->config()->sharedAccessKey($store);

        return 'SharedKey '.base64_encode($username.':'.hash('sha256', $payload.$path.$sharedAccessKey));
    }
}
