<?php

namespace CollectorCheckoutTest\Helper;

use CollectorCheckoutTest\CollectorTestCase;

class WebhookTest extends CollectorTestCase
{
    public function testNotificationOrValidation()
    {
        $helper = new \Crossroads_CollectorCheckout_Helper_Webhook();
        $payment = new \Varien_Object([]);

        $collectorInfoResponse = $this->loadJSONFile(__DIR__.'/../data/checkout-info.json');

        $sessionMock = $this->mockHelper(
            'Crossroads_CollectorCheckout/checkout',
            \Crossroads_CollectorCheckout_Helper_Checkout::class
        );

        $sessionMock->shouldReceive('acquireInformationAboutACheckoutSession')
            ->once()->with($collectorInfoResponse->id)
            ->andReturn($collectorInfoResponse);

        $sessionMock->shouldReceive('saveInfoOnPayment')->once();

        $quoteModel = $this->mockModel(
            'sales/quote',
            \Varien_Object::class
        );

        $quoteModel->shouldReceive('load')
            ->once()->with('100000087', 'reserved_order_id')
            ->andReturn($quoteModel);

        $quoteModel->shouldReceive('getPayment')
            ->andReturn($payment);

        $result = $helper->notificationOrValidation($collectorInfoResponse->id);

        $this->assertEquals($quoteModel, $result);
    }
}
