<?php

class Crossroads_CollectorCheckout_Model_Payment_Checkout extends Crossroads_API_Payment_Abstract
{
    /**
     * @return string
     */
    public function getCode()
    {
        return 'Crossroads_CollectorCheckout';
    }

    /**
     * @return string|null
     */
    public function getControllerClassName()
    {
        return 'Crossroads_CollectorCheckout_Controller_Payment';
    }

    /**
     * @param Mage_Sales_Model_Quote $quote
     * @return array|null
     */
    public function getPaymentMethodData($quote)
    {
        return [
            'publicToken' => $this->checkoutHelper()->getOrCreatePublicToken(),
        ];
    }

    /**
     * @param Mage_Sales_Model_Quote $_quote
     * @return bool
     */
    public function isQuoteInvalid($_quote)
    {
        return false;
    }

    /**
     * @param Mage_Sales_Model_Quote $_order
     */
    public function getOrderPaymentData($_order)
    {
        return null;
    }

    /**
     * @return Crossroads_CollectorCheckout_Helper_Checkout
     */
    protected function checkoutHelper()
    {
        return Mage::helper('Crossroads_CollectorCheckout/checkout');
    }
}
