<?php

class Crossroads_CollectorCheckout_Model_Observer_CheckoutObserver
{

  /**
   * @return Crossroads_CollectorCheckout_Helper_Checkout
   */
  protected function checkoutHelper()
  {
    return Mage::helper('Crossroads_CollectorCheckout/checkout');
  }


  public function updateCollectorCheckout($event) {
    $quote = $event->getQuote();

    if (!$quote) {
      return;
    }

    if (!$this->checkoutHelper()->quoteUsesThisPaymentMethod($quote)) {
        return;
    }

    // Make sure token has not expired.
    if (!$this->checkoutHelper()->getPublicToken()) {
        return;
    }

    if ($this->checkoutHelper()->quoteIsLockedForChanges($quote) &&
      ($this->checkoutHelper()->hasCartChanges($quote) ||
      $this->checkoutHelper()->hasFeesChanges($quote))) {
      throw Crossroads_API_ResponseException::create(403,
        'Payment has been validated and order is awaiting checkout. Modifications to the cart is not allowed.');
    }

    if (0 === count($quote->getAllVisibleItems())) {
        return;
    }

    if ($this->checkoutHelper()->hasCartChanges($quote)) {
      $this->checkoutHelper()->updateCart($quote);
    }

    if ($this->checkoutHelper()->hasFeesChanges($quote)) {
      $this->checkoutHelper()->updateFees($quote);
    }
  }
}