<?php

class Crossroads_CollectorCheckout_Model_Observer_CartObserver
{
    /**
     * @return Crossroads_CollectorCheckout_Helper_Checkout
     */
    protected function checkoutHelper()
    {
        return Mage::helper('Crossroads_CollectorCheckout/checkout');
    }

    /**
     * @param Varien_Event_Observer $observer
     * @throws Exception
     */
    public function checkoutCartSaveAfter(Varien_Event_Observer $observer)
    {
        /** @var Mage_Checkout_Model_Cart $cart */
        $cart = $observer->getCart();

        if (!$cart->hasDataChanges()) {
            return;
        }

        $quote = $cart->getCheckoutSession()->getQuote();

        if (!$this->checkoutHelper()->quoteUsesThisPaymentMethod($quote)) {
            return;
        }

        // Make sure token has not expired.
        if (!$this->checkoutHelper()->getPublicToken()) {
            return;
        }

        if ($this->checkoutHelper()->quoteIsLockedForChanges($quote)) {
            throw Crossroads_API_ResponseException::create(403,
                'Payment has been validated and order is awaiting checkout. Modifications to the cart is not allowed.');
        }

        if (0 === $cart->getItemsCount()) {
            // We cant have an empty cart in collector.
            // Is there a way to suspend the checkout without deleting the public token?
            return;
        }

        if ($this->checkoutHelper()->hasCartChanges($quote)) {
            $this->checkoutHelper()->updateCart($quote);
        }

        if ($this->checkoutHelper()->hasFeesChanges($quote)) {
            $this->checkoutHelper()->updateFees($quote);
        }
    }

    /**
     * @param Varien_Event_Observer $observer
     * @throws Exception
     */
    public function salesQuoteCollectTotalsAfter(Varien_Event_Observer $observer)
    {
        /** @var Mage_Sales_Model_Quote $quote */
        $quote = $observer->getQuote();

        if (!$this->checkoutHelper()->quoteUsesThisPaymentMethod($quote)) {
            return;
        }

        // Make sure token has not expired.
        if (!$this->checkoutHelper()->getPublicToken()) {
            return;
        }

        if ($this->checkoutHelper()->hasFeesChanges($quote)) {
            if ($this->checkoutHelper()->quoteIsLockedForChanges($quote)) {
                $this->cancelInvoice($quote);
            }
            $this->checkoutHelper()->updateFees($quote);
        }

        if ($this->checkoutHelper()->hasCustomerChanges($quote)) {
            // If there are changes to the customer we need to cancel the invoice
            $this->cancelInvoice($quote);
        }
    }

    /**
     * @param Mage_Sales_Model_Quote $quote
     * @return void
     */
    protected function cancelInvoice($quote)
    {
        $payment     = $quote->getPayment();
        $invoiceId   = $payment->getAdditionalInformation(Crossroads_Collector_Helper_Data::FIELD_INVOICE_ID);

        // Check if we have collector invoice id
        if (!empty($invoiceId)) {

            // Cancel invoice and unlock quote.
            try {
                $isFallback       = $payment->getAdditionalInformation(Crossroads_Collector_Helper_Data::FIELD_USING_FALLBACK);
                $isCompany        = $payment->getAdditionalInformation(Crossroads_Collector_Helper_Data::FIELD_IS_COMPANY);
                $store            = Mage::app()->getStore($quote->getStoreId());
                $collectorStoreId = $store->getConfig(Mage::helper("Crossroads_Collector")->getStoreIdKey($isFallback, $isCompany));

                Mage::helper("Crossroads_Collector/soap")->cancelInvoice($store, $collectorStoreId, $quote);
                Mage::log(sprintf("Crossroads_CollectorCheckout: Invoice %s in store %s was stuck, canceled it.", $invoiceId, $collectorStoreId));

                // Reset payment data
                $this->checkoutHelper()->cancel($payment);
                /*
                 * TODO: need to reset session info?
                 * $info = Mage::helper("Crossroads_CollectorCheckout/Checkout")->getInfo($payment);
                 * $info["reference"] = null;
                 * $info["cart"] = null;
                 * $info["fees"] = null;
                 * $info["purchase"] = null;
                 * $info["order"] = null;
                 * $payment->setAdditionalInformation(Crossroads_CollectorCheckout_Helper_Checkout::FIELD_INFO, json_encode($info));
                 * $payment->save();
                 */

                return;
            }
            catch(Exception $e) {
                Mage::logException($e);
            }
        }

        throw Crossroads_API_ResponseException::create(403,
            sprintf("Payment has been stuck. Unable to cancel collector invoice %s.", $invoiceId));
    }
}
