<?php

class Crossroads_CheckoutRegistration_Model_Observer extends Mage_Core_Model_Abstract
{
  const CONFIG_ACTIVE = "CheckoutRegistration/general/activated";

  protected $KEYS = [
    "email",
    "password",
  ];

  protected $REQUIRED = [
    "email",
    "password",
  ];

  protected $ADDRESS_FIELDS = [
    "email",
    "prefix",
    "firstname",
    "middlename",
    "lastname",
    "suffix",
    "company",
    "street",
    "city",
    "region",
    "region_id",
    "postcode",
    "country_id",
    "telephone",
    "fax",
  ];

  protected $data = [];

  private function addressEq($a, $b) {
    $ad = array_intersect_key($a->getData(), array_flip($this->ADDRESS_FIELDS));
    $bd = array_intersect_key($b->getData(), array_flip($this->ADDRESS_FIELDS));

    return count(array_diff_assoc($ad, $bd)) === 0 && count(array_diff_assoc($bd, $ad)) === 0;
  }

  private function customerExists($email) {
    $old_customer = Mage::getModel("customer/customer")->setWebsiteId(Mage::app()->getStore()->getWebsiteId())->loadByEmail($email);
    return (!empty($old_customer->getEmail()));
  }

  public function checkoutPreMerge($observer) {
    $params = array_key_exists("customer", $observer->getParams()->getData()) ? $observer->getParams()->getData()["customer"] : [];
    $store  = Mage::app()->getStore();
    $data   = [];

    foreach($this->KEYS as $k) {
      if(array_key_exists($k, $params)) {
        if( ! is_string($params[$k])) {
          // TODO: Error code
          throw Crossroads_API_ResponseException::create(400, sprintf("Expected \"%s\" to be a string.", $k));
        }

        $data[$k] = $params[$k];
      }
    }

    if ( ! $store->getConfig(self::CONFIG_ACTIVE) || Mage::getSingleton("customer/session")->isLoggedIn()) {
      return;
    }

    if (empty($data)) {
      return;
    }

    if( ! empty($data)) {
      $keys = array_diff($this->REQUIRED, array_keys($data));

      if( ! empty($keys)) {
        throw Crossroads_API_ResponseException::create(400, sprintf("Missing required parameters %s.", implode(", ", $keys)));
      }
    }

    if ($this->customerExists($data["email"])) {
      throw Crossroads_API_ResponseException::create(400, sprintf("The email is already in use."), null, -7500);
    }

    if (array_key_exists("attributes", $params)) {
      $data["attributes"] = $params["attributes"];
    } else {
      $data["attributes"] = [];
    }

    $this->data = $data;
  }

  public function orderSaveAfter($observer) {
    $store = Mage::app()->getStore();
    $sess  = Mage::getSingleton("customer/session");

    if ( ! $store->getConfig(self::CONFIG_ACTIVE) || empty($this->data) || $sess->isLoggedIn()) {;
      return;
    }

    $order    = $observer->getOrder();
    $quote    = $observer->getQuote();
    $shipping = $quote->getShippingAddress();
    $billing  = $quote->getBillingAddress();

    try {
      $customer = Mage::helper("API/customer")->createCustomer([
        "email"      => $this->data["email"],
        "password"   => $this->data["password"],
        "firstname"  => $billing->getFirstname(),
        "lastname"   => $billing->getLastname(),
        "company"    => $billing->getCompany(),
        "attributes" => $this->data["attributes"]
      ]);

      $same = $this->addressEq($shipping, $billing);

      if( ! $same) {
        $addr = $billing->exportCustomerAddress()
                ->setCustomerId($customer->getId())
                ->setIsDefaultBilling(true)
                ->setIsDefaultShipping(false)
                ->save();
      }

      $addr = $shipping->exportCustomerAddress()
               ->setCustomerId($customer->getId())
               ->setIsDefaultBilling($same)
               ->setIsDefaultShipping(true)
               ->save();

      $order->setCustomer($customer)
            ->save();

      $sess->loginById($customer->getId());
    } catch (Exception $e) {
      Mage::logException($e);
    }
  }
}