<?php

class Crossroads_CheckoutNewsletter_Model_Observer extends Mage_Core_Model_Abstract
{
    public function subscribeToNewsletter(Varien_Event_Observer $observer)
    {
        $storeId = Mage::app()->getStore()->getId();
        if (!Mage::getStoreConfig('Newsletter_section/general/active', $storeId)) {
            return;
        }

        $quote  = $observer->getEvent()->getQuote();
        $params = $observer->getEvent()->getParams();
        $email  = $quote->getCustomerEmail();

        if (!empty($params->getData('subscribe_to_newsletter')) && $email) {
            Mage::getModel('newsletter/subscriber')->setStoreId($storeId)->subscribe($email);
        }
    }
}
