<?php

$this->startSetup();

$this->addAttribute(Mage_Catalog_Model_Category::ENTITY, 'cls_catfields_hero_heading', [
    'group'         => 'Hero',
    'input'         => 'text',
    'type'          => 'text',
    'label'         => 'Heading',
    'backend'       => '',
    'visible'       => true,
    'required'      => false,
    'visible_on_front' => true,
    'sort_order'    => 10,
    'global'        => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
]);

$this->addAttribute(Mage_Catalog_Model_Category::ENTITY, 'cls_catfields_hero_percentage', [
    'group'         => 'Hero',
    'input'         => 'text',
    'type'          => 'text',
    'label'         => 'Offer icon',
    'backend'       => '',
    'visible'       => true,
    'required'      => false,
    'visible_on_front' => true,
    'note'             => 'The little red ribbon',
    'sort_order'    => 20,
    'global'        => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
]);

$this->addAttribute(Mage_Catalog_Model_Category::ENTITY, 'cls_catfields_hero_desc', [
    'group'         => 'Hero',
    'input'         => 'textarea',
    'type'          => 'text',
    'label'         => 'Description',
    'backend'       => '',
    'visible'       => true,
    'required'      => false,
    'wysiwyg_enabled' => true,
    'visible_on_front' => true,
    'is_html_allowed_on_front' => true,
    'sort_order'    => 30,
    'global'        => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
]);

$this->addAttribute(Mage_Catalog_Model_Category::ENTITY, 'cls_catfields_hero_cta_text', [
    'group'         => 'Hero',
    'input'         => 'text',
    'type'          => 'text',
    'label'         => 'Button text',
    'backend'       => '',
    'visible'       => true,
    'required'      => false,
    'visible_on_front' => true,
    'sort_order'    => 40,
    'global'        => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
]);

$this->addAttribute(Mage_Catalog_Model_Category::ENTITY, 'cls_catfields_hero_modifier', [
    'group'         => 'Hero',
    'input'         => 'text',
    'type'          => 'text',
    'label'         => 'Hero modifier',
    'backend'       => '',
    'visible'       => true,
    'required'      => false,
    'visible_on_front' => true,
    'sort_order'    => 40,
    'note'             => 'e.g. primary, left, right, white',
    'global'        => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
]);

$this->addAttribute(Mage_Catalog_Model_Category::ENTITY, 'cls_catfields_hero_link', [
    'group'         => 'Hero',
    'input'         => 'text',
    'type'          => 'text',
    'label'         => 'Button Link',
    'backend'       => '',
    'visible'       => true,
    'required'      => false,
    'visible_on_front' => true,
    'note'             => 'example: http://google.se or /category-name',
    'sort_order'    => 50,
    'global'        => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
]);

$this->addAttribute(Mage_Catalog_Model_Category::ENTITY, 'cls_catfields_general_img_s', [
    'group'         => 'General Information',
    'input'         => 'image',
    'type'          => 'varchar',
    'label'         => 'Category image small',
    'backend'       => 'catalog/category_attribute_backend_image',
    'visible'       => true,
    'required'      => false,
    'visible_on_front' => true,
    'global'        => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
    'sort_order'    => 300
]);

$this->addAttribute(Mage_Catalog_Model_Category::ENTITY, 'cls_catfields_general_img_m', [
    'group'         => 'General Information',
    'input'         => 'image',
    'type'          => 'varchar',
    'label'         => 'Category image medium',
    'backend'       => 'catalog/category_attribute_backend_image',
    'visible'       => true,
    'required'      => false,
    'visible_on_front' => true,
    'global'        => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
    'sort_order'    => 400
]);

$this->addAttribute(Mage_Catalog_Model_Category::ENTITY, 'cls_catfields_general_img_l', [
    'group'         => 'General Information',
    'input'         => 'image',
    'type'          => 'varchar',
    'label'         => 'Category image large',
    'backend'       => 'catalog/category_attribute_backend_image',
    'visible'       => true,
    'required'      => false,
    'visible_on_front' => true,
    'global'        => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
    'sort_order'    => 500
]);


// create base64 cache table

$this->run("
    CREATE TABLE IF NOT EXISTS {$this->getTable('crossroads_categoryimagecache')} (
     `name` varchar(255) NOT NULL,
     `data` TEXT NOT NULL,
     PRIMARY KEY  (`name`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
");

$this->endSetup();