# Crossroads CategoryFields module

Adds a couple of extra fields to the category providing additional information to display
to the user. It also includes placeholder images which has the same proportions.

## Fields

### Category Hero data

```
"hero": {
	"heading":     "Welcome to the category!",
	"description": "This is a pretty cool category, check it out!",
	"offerIcon":   "New!",
	"modifier":    "right",
	"button": {
		"text": "Explore the contents",
		"link": "/some-link"
	}
}
```

### Category Image data

The `images` key contains a key-value map with `url` to the actual image and a `dataUrl`
containing a small base64-encoded image with the same aspect ratio as the actual image.

**NOTE:** Image data is only present on category details pages. The category listing will
also include them if the query-parameter `includeImages` is set to `true`.

```
"images": {
	"small": {
		"url":     "http://example.com/media/small_category_hero_image.jpg",
		"dataUrl": "data:image\/jpeg;base64,..."
	},
	"medium": {
		"url":     "http://example.com/media/medium_category_hero_image.jpg",
		"dataUrl": "data:image\/jpeg;base64,..."
	},
	"large": {
		"url":     "http://example.com/media/large.jpg",
		"dataUrl": "data:image\/jpeg;base64,..."
	}
}
```

## Requirements

* [Composer](https://getcomposer.org/download/)

## Composer.json

Add the following to your `composer.json`:

```
{
	"name": "Your project name",
	"description": "Your project description",
	"require": {
		"Crossroads_API": "dev-master",
		"magento-hackathon/magento-composer-installer": "*"
	},
	"repositories": [
		{
			"type": "vcs",
			"url":  "git@groot.crossroads.se:modules/CategoryFields.git"
		}
	],
	"extra": {
		"magento-root-dir":      ".",
		"auto-append-gitignore": true
	}
}
```
