<?php
class Crossroads_Carousel_Block_Adminhtml_Slide_Edit_Form extends Mage_Adminhtml_Block_Widget_Form
{
    protected function _prepareForm() {
        // Instantiate a new form to display our slide for editing.
        $form = new Varien_Data_Form([
            'id' => 'edit_form',
            'action' => $this->getUrl(
                'adminhtml/slide_slide/edit',
                [
                    '_current' => true,
                    'continue' => 0,
                ]
            ),
            'method' => 'post',
            'enctype' => 'multipart/form-data'
        ]);
        $form->setUseContainer(true);
        $this->setForm($form);

        $slideSingleton = Mage::getSingleton('crossroads_carousel/slide');

        // Define a new fieldset. We need only one for our simple entity.
        $fieldset = $form->addFieldset('general',
            [
                'legend' => $this->__('Slide Details')
            ]
        );

        // Add the fields that we want to be editable.
        $this->_addFieldsToFieldset($fieldset, [
            'name' => [
                'label' => $this->__('Name'),
                'input' => 'text',
                'required' => true,
            ],
            'url' => [
                'label' => $this->__('URL'),
                'input' => 'text',
            ],
            'content_type' => [
                'label'     => $this->__('Content Type'),
                'input'     => 'select',
                'onchange'  => 'onContentTypeChange(event)',
                'values'    => $slideSingleton->getAvailableContentTypes()
            ],
            'html' => [
                'label'     => $this->__('HTML'),
                'style'     => 'height:15em: width: 100%;',
                'config'    => Mage::getSingleton('cms/wysiwyg_config')->getConfig(),
                'input'     => 'editor',
                'wysiwyg'   => true,
                'required'  => false,
            ],
            'image' => [
                'name'  => 'image',
                'label' => $this->__('Image'),
                'input' => 'image',
            ]
        ]);

        return $this;
    }

    protected function _addFieldsToFieldset(Varien_Data_Form_Element_Fieldset $fieldset, $fields) {
        $requestData = new Varien_Object($this->getRequest()->getPost('slideData'));
        $lastField = null;

        foreach ($fields as $name => $_data) {
            if ($requestValue = $requestData->getData($name)) {
                $_data['value'] = $requestValue;
            }

            $_data['name'] = "slideData[$name]";
            $_data['title'] = $_data['label'];

            // If no new value exists, use the existing slide data.
            if (!array_key_exists('value', $_data)) {
                $_data['value'] = $this->_getSlide()->getData($name);
            }

            $lastField = $fieldset->addField($name, $_data['input'], $_data);
        }

        $lastField->setAfterElementHtml('
            <script>
                function updateContentType(type) {
                    var image = $("image").parentNode.parentNode;
                    var html = $("html").parentNode.parentNode;
                    switch (type) {
                        case "IMAGE":
                            image.show()
                            html.hide()
                        break;
                        case "HTML":
                            html.show()
                            image.hide()
                        break;
                    }

                }
                function onContentTypeChange(e) {
                    updateContentType(e.target.value);
                }
                updateContentType($("content_type").value);
            </script>
        ');


        return $this;
    }

    /**
     * Retrieve the existing slide for pre-populating the form fields.
     * For a new slide entry, this will return an empty slide object.
     */
    protected function _getSlide() {
        if (!$this->hasData('slide')) {
            // This will have been set in the controller.
            $slide = Mage::registry('current_slide');

            // Just in case the controller does not register the slide.
            if (!$slide instanceof Crossroads_Carousel_Model_Slide) {
                $slide = Mage::getModel('crossroads_carousel/slide');
            }

            $this->setData('slide', $slide);
        }

        return $this->getData('slide');
    }
}