<?php
class Crossroads_Carousel_Adminhtml_Carousel_CarouselController extends Mage_Adminhtml_Controller_Action
{
    /**
     * Instantiate our grid container block and add to the page content.
     * When accessing this admin index page, we will see a grid of all
     * carousels currently available in our Magento instance, along with
     * a button to add a new one if we wish.
     */
    public function indexAction()
    {
        // instantiate the grid container
        $carouselBlock = $this->getLayout()
            ->createBlock('crossroads_carousel_adminhtml/carousel');

        // Add the grid container as the only item on this page
        $this->loadLayout()
            ->_addContent($carouselBlock)
            ->renderLayout();
    }

    /**
     * This action handles both viewing and editing existing carousels.
     */
    public function editAction()
    {
        /**
         * Retrieve existing carousel data if an ID was specified.
         * If not, we will have an empty carousel entity ready to be populated.
         */
        $carousel = Mage::getModel('crossroads_carousel/carousel');
        if ($carouselId = $this->getRequest()->getParam('id', false)) {
            $carousel->load($carouselId);

            if ($carousel->getId() < 1) {
                $this->_getSession()->addError($this->__('This carousel no longer exists.'));
                return $this->_redirect(
                    'crossroads_carousel_admin/carousel/index'
                );
            }
        }

        // process $_POST data if the form was submitted
        if ($postData = $this->getRequest()->getPost('carouselData')) {
            try {
                // Save stores
                if (isset($postData['store_id'])) {
                    $postData['store_id'] = implode(",", $postData['store_id']);
                }

                $postData['slides'] = explode(',', $postData['slides']);
                $carousel->addData($postData);
                $carousel->save();

                $this->_getSession()->addSuccess(
                    $this->__('The carousel has been saved.')
                );

                // redirect to remove $_POST data from the request
                return $this->_redirect(
                    'adminhtml/carousel_carousel/edit',
                    array('id' => $carousel->getId())
                );
            } catch (Exception $e) {
                Mage::logException($e);
                $this->_getSession()->addError($e->getMessage());
            }

            /**
             * If we get to here, then something went wrong. Continue to
             * render the page as before, the difference this time being
             * that the submitted $_POST data is available.
             */
        }


        // Make the current carousel object available to blocks.
        $carousel->setSlides($carousel->getResource()->getSlides($carousel));
        Mage::register('current_carousel', $carousel);

        // Instantiate the form container.
        $carouselEditBlock = $this->getLayout()->createBlock(
            'crossroads_carousel_adminhtml/carousel_edit'
        );

        // Add the form container as the only item on this page.
        $this->loadLayout()->_addContent($carouselEditBlock);

        $this->renderLayout();
    }

    public function deleteAction()
    {
        $carousel = Mage::getModel('crossroads_carousel/carousel');

        if ($carouselId = $this->getRequest()->getParam('id', false)) {
            $carousel->load($carouselId);
        }

        if ($carousel->getId() < 1) {
            $this->_getSession()->addError($this->__('This carousel no longer exists.'));
            return $this->_redirect(
                'adminhtml/carousel_carousel/index'
            );
        }

        try {
            $carousel->delete();
            $this->_getSession()->addSuccess($this->__('The carousel has been deleted.'));
        } catch (Exception $e) {
            Mage::logException($e);
            $this->_getSession()->addError($e->getMessage());
        }

        return $this->_redirect(
            'adminhtml/carousel_carousel/index/'
        );
    }

    protected function _isAllowed()
    {
        return Mage::getSingleton('admin/session')->isAllowed('crossroads_carousel/carousel');
    }
}