<?php
class Crossroads_Carousel_Block_Adminhtml_Slide_Grid extends Mage_Adminhtml_Block_Widget_Grid
{
    protected function _prepareCollection()
    {
        /**
         * Tell Magento which collection to use to display in the grid.
         */
        $collection = Mage::getResourceModel(
            'crossroads_carousel/slide_collection'
        );

        foreach($collection as $link) {
            if ($link->getStoreId() && $link->getStoreId() != 0 ) {
                $link->setStoreId(explode(',',$link->getStoreId()));
            }
            else {
                $link->setStoreId(array('0'));
            }
        }

        $this->setCollection($collection);

        return parent::_prepareCollection();
    }

    public function getRowUrl($row)
    {
        return $this->getUrl(
            'adminhtml/slide_slide/edit',
            [
                'id' => $row->getId()
            ]
        );
    }

    protected function _prepareColumns()
    {
        /**
         * Here, we'll define which columns to display in the grid.
         */
        $this->addColumn('entity_id', [
            'header' => $this->_getHelper()->__('ID'),
            'type' => 'number',
            'index' => 'entity_id',
        ]);

        $this->addColumn('created_at', [
            'header' => $this->_getHelper()->__('Created'),
            'type' => 'datetime',
            'index' => 'created_at',
        ]);

        $this->addColumn('updated_at', [
            'header' => $this->_getHelper()->__('Updated'),
            'type' => 'datetime',
            'index' => 'updated_at',
        ]);

        $this->addColumn('name', [
            'header' => $this->_getHelper()->__('Name'),
            'type' => 'text',
            'index' => 'name',
        ]);

        $slideSingleton = Mage::getSingleton('crossroads_carousel/slide');

        $this->addColumn('content_type', [
            'header' => $this->_getHelper()->__('Content Type'),
            'type' => 'options',
            'index' => 'content_type',
            'options' => $slideSingleton->getAvailableContentTypes()
        ]);

        /**
         * Finally, we'll add an action column with an edit link.
         */
        $this->addColumn('action', [
            'header' => $this->_getHelper()->__('Action'),
            'width' => '50px',
            'type' => 'action',
            'actions' => [
                [
                    'caption' => $this->_getHelper()->__('Edit'),
                    'url' => [
                        'base' => 'adminhtml/slide_slide/edit',
                    ],
                    'field' => 'id'
                ],
            ],
            'filter' => false,
            'sortable' => false,
            'index' => 'entity_id',
        ]);

        return parent::_prepareColumns();
    }

    protected function _filterStoreCondition($collection, $column){
        if (!$value = $column->getFilter()->getValue()) {
            return;
        }
        $this->getCollection()->addStoreFilter($value);
    }


    protected function _getHelper()
    {
        return Mage::helper('crossroads_carousel');
    }
}