<?php
class Crossroads_Carousel_Model_Slide extends Mage_Core_Model_Abstract
{
    const CONTENT_TYPE_IMAGE = 'IMAGE';
    const CONTENT_TYPE_HTML  = 'HTML';

    protected function _construct()
    {
        $this->_init('crossroads_carousel/slide');
    }

    public function getImageUrl()
    {
        $img = $this->getImage();
        return (empty($img)) ? null : Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_MEDIA) . DS . $img;
    }

    public function isActive() {
        return true;
    }

    public function getAvailableContentTypes()
    {
        return [
            self::CONTENT_TYPE_HTML  => Mage::helper('crossroads_carousel')->__('HTML'),
            self::CONTENT_TYPE_IMAGE => Mage::helper('crossroads_carousel')->__('IMAGE'),
        ];
    }

    protected function _beforeSave()
    {
        parent::_beforeSave();

        /**
         * Perform some actions just before a slide is saved.
         */
        $this->_updateTimestamps();

        return $this;
    }

    protected function _updateTimestamps()
    {
        $timestamp = now();

        /**
         * Set the last updated timestamp.
         */
        $this->setUpdatedAt($timestamp);

        /**
         * If we have a brand new object, set the created timestamp.
         */
        if ($this->isObjectNew()) {
            $this->setCreatedAt($timestamp);
        }

        return $this;
    }
}