<?php
class Crossroads_Carousel_Block_Adminhtml_Carousel extends Mage_Adminhtml_Block_Widget_Grid_Container
{
    protected function _construct()
    {
        parent::_construct();

        /**
         * The $_blockGroup property tells Magento which alias to use to
         * locate the blocks to be displayed in this grid container.
         * In our example, this corresponds to /Block/Adminhtml.
         */
        $this->_blockGroup = 'crossroads_carousel_adminhtml';

        /**
         * $_controller is a slightly confusing name for this property.
         * This value, in fact, refers to the folder containing our
         * Grid.php and Edit.php - in our example,
         * /Block/Adminhtml/Carousel. So, we'll use 'carousel'.
         */
        $this->_controller = 'carousel';

        /**
         * The title of the page in the admin panel.
         */
        $this->_headerText = Mage::helper('crossroads_carousel')->__('Carousel');
    }

    public function getCreateUrl()
    {
        return $this->getUrl('adminhtml/carousel_carousel/edit');
    }
}