<?php

$this->startSetup();

$conn = $this->getConnection();

// create slide table
$table = $conn->newTable($this->getTable('crossroads_carousel/slide'))
->addColumn('entity_id', Varien_Db_Ddl_Table::TYPE_INTEGER, 10,
    [
        'auto_increment' => true,
        'unsigned'       => true,
        'nullable'       => false,
        'primary'        => true
    ]
)
->addColumn('created_at', Varien_Db_Ddl_Table::TYPE_DATETIME, null)
->addColumn('updated_at', Varien_Db_Ddl_Table::TYPE_DATETIME, null)
->addColumn('name', Varien_Db_Ddl_Table::TYPE_VARCHAR, 255, [
        'nullable' => true
    ]
)
->addColumn('url', Varien_Db_Ddl_Table::TYPE_VARCHAR, 255, [
        'nullable' => true
    ]
)
->addColumn('content_type', Varien_Db_Ddl_Table::TYPE_VARCHAR, null)
->addColumn('html', Varien_Db_Ddl_Table::TYPE_TEXT, null)
->addColumn('image', Varien_Db_Ddl_Table::TYPE_TEXT, null)
->setOption('type', 'InnoDB')
->setOption('charset', 'utf8');

$conn->createTable($table);

// create carousel table
$table = $conn->newTable($this->getTable('crossroads_carousel/carousel'))
->addColumn(
    'entity_id',
    Varien_Db_Ddl_Table::TYPE_INTEGER,
    10,
    [
        'auto_increment' => true,
        'unsigned'       => true,
        'nullable'       => false,
        'primary'        => true
    ]
)
->addColumn('created_at', Varien_Db_Ddl_Table::TYPE_DATETIME, null)
->addColumn('updated_at', Varien_Db_Ddl_Table::TYPE_DATETIME, null)
->addColumn('name', Varien_Db_Ddl_Table::TYPE_VARCHAR, 255, [
        'nullable' => true
    ]
)
->addColumn('status', Varien_Db_Ddl_Table::TYPE_BOOLEAN, false)
->addColumn('store_id', Varien_Db_Ddl_Table::TYPE_VARCHAR, 255, [
        'nullable' => true
    ]
)
->setOption('type', 'InnoDB')
->setOption('charset', 'utf8');

$conn->createTable($table);

// linked table
$table = $conn->newTable($this->getTable('crossroads_carousel/carousel_slide'))
->addColumn('carousel_id', Varien_Db_Ddl_Table::TYPE_INTEGER, 10, [
        'unsigned' => true,
        'nullable' => false,
        'primary'  => true
    ]
)
->addColumn('slide_id', Varien_Db_Ddl_Table::TYPE_INTEGER, 10, [
        'unsigned' => true,
        'nullable' => false,
        'primary'  => true
    ]
)
->addColumn('position', Varien_Db_Ddl_Table::TYPE_INTEGER, 10, [
        'unsigned' => true,
        'nullable' => false,
        'default'  => 0
    ]
)
->addForeignKey(
    $this->getFkName(
        "crossroads_carousel/carousel_slide", "carousel_id",
        "crossroads_carousel/carousel", "entity_id"
    ),
    "carousel_id", $this->getTable("crossroads_carousel/carousel"), "entity_id",
    Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE
)
->addForeignKey(
    $this->getFkName(
        "crossroads_carousel/carousel_slide", "slide_id",
        "crossroads_carousel/slide", "entity_id"
    ),
    "slide_id", $this->getTable("crossroads_carousel/slide"), "entity_id",
    Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE
);

$conn->createTable($table);

$this->endSetup();