<?php
class Crossroads_Carousel_CarouselController extends Crossroads_API_Controller_Resource
{
	/**
     * @api {get} /carousel Fetch a list of all Carousels
     * @apiName getCarousels
     * @apiGroup Carousel
     *
     * @apiSuccess {Integer} id
     * @apiSuccess {String} name
     * @apiSuccess {String} description
     * @apiSuccess {String} image
     * @apiSuccess {String} logotype
     * @apiSuccess {Object} callToAction
     * @apiSuccess {String} callToAction.url
     * @apiSuccess {String} callToAction.label
     */
    public function getAll() {
        $carousels = Mage::helper('crossroads_carousel')->getAll();

        return [200, $carousels];
    }

    /**
     * @api {get} /carousel/:id Request Carousel page
     * @apiName getCarousel
     * @apiGroup Carousel
     *
     * @apiParam {Integer} id The ID of the carousel
     * @apiSuccess {Integer} id
     * @apiSuccess {String} name
     * @apiSuccess {String} description
     * @apiSuccess {String} image
     * @apiSuccess {String} logotype
     * @apiSuccess {Object} callToAction
     * @apiSuccess {String} callToAction.url
     * @apiSuccess {String} callToAction.label
     *
     */
    public function getItem($id)
    {
        $carousel = Mage::helper('crossroads_carousel')->getItem($id);

        if (empty($carousel)) {
            return [404];
        }

        return [200, $carousel];
    }
}