<?php
class Crossroads_Carousel_Adminhtml_Slide_SlideController extends Mage_Adminhtml_Controller_Action
{
    private function _uploadImage($files, $postData, $index) {
        if(isset($postData[$index]['delete']) && $postData[$index]['delete'] == 1) {
            // We're choosing to not delete the image from the hard drive
            // on purpose. I don't have time to add safety checks.
            $postData[$index] = '';
            return $postData;
        }
        if (isset($files['name'][$index]) && file_exists($files['tmp_name'][$index])) {
            $uploader = new Varien_File_Uploader(
                [
                    'name'     => $files['name'][$index],
                    'type'     => $files['type'][$index],
                    'tmp_name' => $files['tmp_name'][$index],
                    'error'    => $files['error'][$index],
                    'size'     => $files['size'][$index]
                ]);

            $uploader->setAllowedExtensions(['jpg','jpeg','gif','png']);
            $uploader->setAllowRenameFiles(false);
            $uploader->setFilesDispersion(false);

            $path = Mage::getBaseDir('media') . DS . 'carousel' . DS;

            if (!is_dir($path)) {
                mkdir($path, 0777, true);
            }

            $uploader->save($path, $files['name'][$index]);

            $postData[$index] = 'carousel' . DS . $files['name'][$index];
        } else {
            if(isset($postData['delete']) && $postData['delete'] == 1) {
                $postData[$index] = '';
            } else {
                unset($postData[$index]);
            }
        }
        return $postData;
    }

    /**
     * Instantiate our grid container block and add to the page content.
     * When accessing this admin index page, we will see a grid of all
     * slides currently available in our Magento instance, along with
     * a button to add a new one if we wish.
     */
    public function indexAction()
    {
        // instantiate the grid container
        $slideBlock = $this->getLayout()
            ->createBlock('crossroads_carousel_adminhtml/slide');

        // Add the grid container as the only item on this page
        $this->loadLayout()
            ->_addContent($slideBlock)
            ->renderLayout();
    }

    /**
     * This action handles both viewing and editing existing slides.
     */
    public function editAction()
    {
        /**
         * Retrieve existing slide data if an ID was specified.
         * If not, we will have an empty slide entity ready to be populated.
         */
        $slide = Mage::getModel('crossroads_carousel/slide');
        if ($slideId = $this->getRequest()->getParam('id', false)) {
            $slide->load($slideId);

            if ($slide->getId() < 1) {
                $this->_getSession()->addError($this->__('This slide no longer exists.'));
                return $this->_redirect(
                    'crossroads_carousel_admin/slide/index'
                );
            }
        }

        // process $_POST data if the form was submitted
        if ($postData = $this->getRequest()->getPost('slideData')) {
            try {
                // Save stores
                if (isset($postData['store_id'])) {
                    $postData['store_id'] = implode(",", $postData['store_id']);
                }

                if ($postData['content_type'] === 'IMAGE') {
                    $postData = $this->_uploadImage($_FILES["slideData"], $postData, "image");
                }

                $slide->addData($postData);
                $slide->save();

                $this->_getSession()->addSuccess(
                    $this->__('The slide has been saved.')
                );

                // redirect to remove $_POST data from the request
                return $this->_redirect(
                    'adminhtml/slide_slide/edit',
                    array('id' => $slide->getId())
                );
            } catch (Exception $e) {
                Mage::logException($e);
                $this->_getSession()->addError($e->getMessage());
            }

            /**
             * If we get to here, then something went wrong. Continue to
             * render the page as before, the difference this time being
             * that the submitted $_POST data is available.
             */
        }


        // Make the current slide object available to blocks.
        Mage::register('current_slide', $slide);

        // Instantiate the form container.
        $slideEditBlock = $this->getLayout()->createBlock(
            'crossroads_carousel_adminhtml/slide_edit'
        );

        // Add the form container as the only item on this page.
        $this->loadLayout()->_addContent($slideEditBlock);

        if (Mage::getSingleton('cms/wysiwyg_config')->isEnabled()) {
            $this->getLayout()->getBlock('head')->setCanLoadTinyMce(true);
        }

        $this->renderLayout();
    }

    public function deleteAction()
    {
        $slide = Mage::getModel('crossroads_carousel/slide');

        if ($slideId = $this->getRequest()->getParam('id', false)) {
            $slide->load($slideId);
        }

        if ($slide->getId() < 1) {
            $this->_getSession()->addError($this->__('This slide no longer exists.'));
            return $this->_redirect(
                'adminhtml/slide_slide/index'
            );
        }

        try {
            $slide->delete();
            $this->_getSession()->addSuccess($this->__('The slide has been deleted.'));
        } catch (Exception $e) {
            Mage::logException($e);
            $this->_getSession()->addError($e->getMessage());
        }

        return $this->_redirect(
            'adminhtml/slide_slide/index/'
        );
    }

    protected function _isAllowed()
    {
        return Mage::getSingleton('admin/session')->isAllowed('crossroads_carousel/slide');
    }
}