<?php
class Crossroads_Carousel_Model_Resource_Slide_Collection extends Mage_Core_Model_Resource_Db_Collection_Abstract
{
    protected function _construct() {
        parent::_construct();
        $this->_init('crossroads_carousel/slide', 'crossroads_carousel/slide');
    }

    public function addStoreFilter($store, $withAdmin = true) {
        if ($store instanceof Mage_Core_Model_Store) {
            $store = [$store->getId()];
        }

        if (!is_array($store)) {
            $store = [$store];
        }

        /* only show if in current store or if the slides store is set to "All Store Views" */
        $this->addFieldToFilter(
            [
                "store_id",
                "store_id"
            ],
            [
                ["in" => ["0"]],
                ["finset" => $store],
            ]
        );

        return $this;
    }

    public function addCarouselFilter($carouselId) {
        $this->getSelect()->join(
            ["cs" => $this->getTable("crossroads_carousel/carousel_slide")],
            "main_table.entity_id = cs.slide_id",
            []
        )->where("cs.carousel_id = ?", $carouselId);

        return $this;
    }
}