<?php
class Crossroads_Carousel_Block_Adminhtml_Carousel_Grid extends Mage_Adminhtml_Block_Widget_Grid
{
    protected function _prepareCollection()
    {
        /**
         * Tell Magento which collection to use to display in the grid.
         */
        $collection = Mage::getResourceModel(
            'crossroads_carousel/carousel_collection'
        );

        foreach($collection as $link) {
            if ($link->getStoreId() && $link->getStoreId() != 0 ) {
                $link->setStoreId(explode(',',$link->getStoreId()));
            }
            else {
                $link->setStoreId(array('0'));
            }
        }

        $this->setCollection($collection);

        return parent::_prepareCollection();
    }

    public function getRowUrl($row)
    {
        return $this->getUrl(
            'adminhtml/carousel_carousel/edit',
            [
                'id' => $row->getId()
            ]
        );
    }

    protected function _prepareColumns()
    {
        /**
         * Here, we'll define which columns to display in the grid.
         */
        $this->addColumn('entity_id', [
            'header' => $this->_getHelper()->__('ID'),
            'type' => 'number',
            'index' => 'entity_id',
        ]);

        $this->addColumn('created_at', [
            'header' => $this->_getHelper()->__('Created'),
            'type' => 'datetime',
            'index' => 'created_at',
        ]);

        $this->addColumn('updated_at', [
            'header' => $this->_getHelper()->__('Updated'),
            'type' => 'datetime',
            'index' => 'updated_at',
        ]);

        $this->addColumn('name', [
            'header' => $this->_getHelper()->__('Name'),
            'type' => 'text',
            'index' => 'name',
        ]);

        $carouselSingleton = Mage::getSingleton('crossroads_carousel/carousel');

        $this->addColumn('status', [
            'header' => $this->_getHelper()->__('Status'),
            'type' => 'options',
            'index' => 'status',
            'options' => $carouselSingleton->getAvailableStatuses()
        ]);

        $this->addColumn('store_id', [
            'header'        => $this->_getHelper()->__('Store View'),
            'index'         => 'store_id',
            'type'          => 'store',
            'store_all'     => true,
            'store_view'    => true,
            'sortable'      => true,
            'filter_condition_callback' => [$this, '_filterStoreCondition']
        ]);

        /**
         * Finally, we'll add an action column with an edit link.
         */
        $this->addColumn('action', [
            'header' => $this->_getHelper()->__('Action'),
            'width' => '50px',
            'type' => 'action',
            'actions' => [
                [
                    'caption' => $this->_getHelper()->__('Edit'),
                    'url' => [
                        'base' => 'adminhtml/carousel_carousel/edit',
                    ],
                    'field' => 'id'
                ],
            ],
            'filter' => false,
            'sortable' => false,
            'index' => 'entity_id',
        ]);

        return parent::_prepareColumns();
    }

    protected function _filterStoreCondition($collection, $column){
        if (!$value = $column->getFilter()->getValue()) {
            return;
        }
        $this->getCollection()->addStoreFilter($value);
    }


    protected function _getHelper()
    {
        return Mage::helper('crossroads_carousel');
    }
}