<?php
class Crossroads_Carousel_Block_Adminhtml_Carousel_Edit_Form extends Mage_Adminhtml_Block_Widget_Form
{
    protected function _prepareForm() {
        // Instantiate a new form to display our carousel for editing.
        $form = new Varien_Data_Form([
            'id' => 'edit_form',
            'action' => $this->getUrl(
                'adminhtml/carousel_carousel/edit',
                [
                    '_current' => true,
                    'continue' => 0,
                ]
            ),
            'method' => 'post',
        ]);
        $form->setUseContainer(true);
        $this->setForm($form);

        // Define a new fieldset. We need only one for our simple entity.
        $fieldset = $form->addFieldset('general',
            [
                'legend' => $this->__('Carousel Details')
            ]
        );

        // Add the fields that we want to be editable.
        $this->_addFieldsToFieldset($fieldset, [
            'store_id' => [
                'input'    => 'multiselect',
                'name'     => 'stores[]',
                'label'    => Mage::helper('crossroads_carousel')->__('Store View'),
                'title'    => Mage::helper('crossroads_carousel')->__('Store View'),
                'required' => true,
                'values'   => Mage::getSingleton('adminhtml/system_store')->getStoreValuesForForm(false, true),
            ],
            'name' => [
                'label' => $this->__('Name'),
                'input' => 'text',
                'required' => true,
            ],
            'status' => [
                'label' => $this->__('Status'),
                'input' => 'select',
                'required' => true,
                'options' => Mage::getSingleton('crossroads_carousel/carousel')->getAvailableStatuses(),
            ],
            'slides' => [
                'input'    => 'hidden',
                'label'    => Mage::helper('crossroads_carousel')->__('Slides'),
                'name'     => 'slides',
            ],
        ]);

        return $this;
    }

    protected function _addFieldsToFieldset(Varien_Data_Form_Element_Fieldset $fieldset, $fields) {
        $requestData     = new Varien_Object($this->getRequest()->getPost('carouselData'));
        $lastField       = null;
        $usedSlidesCollection = [];

        foreach ($fields as $name => $_data) {
            if ($requestValue = $requestData->getData($name)) {
                $_data['value'] = $requestValue;
            }

            $_data['name'] = "carouselData[$name]";
            $_data['title'] = $_data['label'];

            if ($_data['name'] === 'carouselData[slides]') {
                $usedSlidesCollection =$this->_getCarousel()->getData('slides')->getItems();
            }

            // If no new value exists, use the existing carousel data.
            if (!array_key_exists('value', $_data) && $_data['name']  !== 'carouselData[slides]') {
                $_data['value'] = $this->_getCarousel()->getData($name);
            }

            $lastField = $fieldset->addField($name, $_data['input'], $_data);
        }

        $usedSlidesIds = [];
        foreach ($usedSlidesCollection as $s) {
            $usedSlidesIds[] = $s->getEntityId();
        }

        $slideCollection = Mage::getModel("crossroads_carousel/slide")
                            ->getCollection();

        if (!empty($usedSlidesIds)) {
            $slideCollection = $slideCollection->addFieldToFilter('entity_id', array('nin'=> $usedSlidesIds));
        }
        $slideCollection = $slideCollection->getItems();

        $slide = function($a) {
            return "
                <div data-name='".$a->getName()."' data-id='".$a->getEntityId()."' class='slide'>
                    <img class='slide__thumbnail' src='" . ($a->getImageUrl() ?: "http://via.placeholder.com/200x51") . "' height='30' />
                    <b class='slide__name'>" . $a->getName() . "</b>
                </div>
            ";
        };

        $availableElements = array_map($slide, $slideCollection);
        $sliderElements = array_map($slide, $usedSlidesCollection);

        $lastField->setAfterElementHtml('
        <style>
            .slide {
                width: 200px;
                background: #fff;
                cursor: move;
                background: #fff;
            }
            .gu-mirror.slide {
                width: 200px !important;
                display: flex;
                flex-direction:column;
                margin-bottom: 0;
            }

            .gu-mirror.slide .slide__thumbnail {
                width: 100%;
                height: auto;
                display: block;
            }

            .slide__thumbnail {
                width: 100%;
                height: auto;
                display: block;
            }

            .slide__name {
                display: block;
                padding: 5px;
            }

            .slide__container {
                box-sizing: border-box;
                border-width: 1px;
                border-style: solid;
                border-color: #aaa #c8c8c8 #c8c8c8 #aaa;
                padding: 10px; 

                margin-right: 10px;
                width: 100%;
                overflow-y: scroll;
                min-width: 1000px;
            }

            .slide__container--used {
                display: flex;
                flex-direction: row;
            }

            .slide__container--available {
                display: flex;
                flex-direction: column;
                height: 230px;
            }

            .slide__container--used .slide {
                margin-right: 5px;
            }

            .slide__container--available .slide {
                width: 100%;
                border-bottom: 1px solid #aaa;
            }

            .slide__container--available .slide__thumbnail {
                display: block;
                width: auto;
                height: 50px;
                float: left;
                margin-right: 15px;
            }

            .slides-filter {
                box-sizing: border-box;
                padding: 10px;
                width: 100%;
                margin: 0;
                margin-bottom: 10px;
            }
        </style>
        <div style="margin-top: 20px; padding-left: 5px;">
            <div>
                <label style="display: block; margin-bottom: 5px;" for="status">Slides <span class="required">*</span></label>
                <div class="slide__container slide__container--used" id="slides--used">' . implode($sliderElements, '') . '</div>
            </div>
            <div style="margin-top: 50px;">
                <label style="display: block; margin-bottom: 5px;" for="status">All available slides</span></label>
                <input placeholder="filter available slides..." class="slides-filter" id="slides-filter" />
                <div class="slide__container slide__container--available" id="slides--available">' . implode($availableElements, '') . '</div>
            </div>
        </div>

        <script>
            var drake = dragula([$("slides--used"), $("slides--available")], { direction: "horizontal" });
            var selectedSlides = [];
            var filterString = "";

            function syncState() {
                var children = Array.from(document.getElementById("slides--used").children);
                var selectedSlides = children.map(x => x.getAttribute("data-id"));
                console.log(selectedSlides)
                $("slides").value = selectedSlides.join(",");
            }

            drake.on("drop", function(el, target, source) {
                syncState();
            });

            document.getElementById("slides-filter").addEventListener("keyup", function(e) {
                filterString = e.target.value;
                $$("#slides--available>div").each(function($item) {
                    if ($item.getAttribute("data-name").toLowerCase().indexOf(e.target.value) !== -1) {
                        $item.style.display = "block";
                    } else {
                        $item.style.display = "none";
                    }
                });
            });

            syncState();
        </script>
        ');

        return $this;
    }

    /**
     * Retrieve the existing carousel for pre-populating the form fields.
     * For a new carousel entry, this will return an empty carousel object.
     */
    protected function _getCarousel() {
        if (!$this->hasData('carousel')) {
            // This will have been set in the controller.
            $carousel = Mage::registry('current_carousel');

            // Just in case the controller does not register the carousel.
            if (!$carousel instanceof Crossroads_Carousel_Model_Carousel) {
                $carousel = Mage::getModel('crossroads_carousel/carousel');
            }

            $this->setData('carousel', $carousel);
        }

        return $this->getData('carousel');
    }
}