<?php
class Crossroads_Carousel_Model_Carousel extends Mage_Core_Model_Abstract
{
    const STATUS_DISABLED = '0';
    const STATUS_ENABLED  = '1';

    protected function _construct()
    {
        $this->_init('crossroads_carousel/carousel');
    }

    public function isActive()
    {
        return $this->status === STATUS_ENABLED;
    }

    /**
     * This method is used in the grid and form for populating the dropdown.
     */
    public function getAvailableStatuses()
    {
        return [
            self::STATUS_DISABLED => Mage::helper('crossroads_carousel')->__('Disabled'),
            self::STATUS_ENABLED  => Mage::helper('crossroads_carousel')->__('Enabled'),
        ];
    }

    protected function _beforeSave()
    {
        parent::_beforeSave();
        $this->_updateTimestamps();

        return $this;
    }

    protected function _afterSave()
    {
        parent::_afterSave();
        $this->_saveLinkedTable();

        return $this;
    }

    protected function _saveLinkedTable()
    {
        $resource = Mage::getSingleton('core/resource');
        $write    = $resource->getConnection('core_write');

        $write->delete($resource->getTableName("crossroads_carousel/carousel_slide"), [ "carousel_id" => $this->getId() ]);

        if ($this->getSlides()[0] == '') {
            return;
        }

        foreach ($this->getSlides() as $i => $id) {
            $write->insert($resource->getTableName("crossroads_carousel/carousel_slide"), [
                "carousel_id" => $this->getId(),
                "slide_id"    => $id,
                "position"    => $i,
            ]);
        }
    }

    protected function _updateTimestamps()
    {
        $timestamp = now();

        /**
         * Set the last updated timestamp.
         */
        $this->setUpdatedAt($timestamp);

        /**
         * If we have a brand new object, set the created timestamp.
         */
        if ($this->isObjectNew()) {
            $this->setCreatedAt($timestamp);
        }

        return $this;
    }
}