<?php

class Crossroads_Carousel_Helper_Data extends Mage_Core_Helper_Abstract
{
    public function getAll() {
    	$store_id = Mage::app()->getStore()->getStoreId();

        $carousels = Mage::getModel("crossroads_carousel/carousel")
            ->getCollection()
            ->addStoreFilter($store_id)
            ->addFieldToFilter("status", "1");

        return array_map(function($carousel) {
        	return $this->prepareCarousel($carousel);
        }, $carousels->getData());
    }

    public function getItem($id) {
    	$carousel = Mage::getModel('crossroads_carousel/carousel')->load($id);

        if(!$id || !$carousel->getId()) {
            return null;
        }

        return $this->prepareCarousel($carousel);
    }

    public function prepareCarousel($carousel) {
    	return [
            "id"   => (int)$carousel["entity_id"],
            "name" => $carousel["name"],
        ];
    }
}