<?php

declare(strict_types=1);

use PHPUnit\Framework\TestCase;

require_once("Mage.php");
require_once("Varien/Object.php");

require_once("Model/Serializer/Abstract.php");
require_once("Model/Serializer/Constant.php");

/**
 * @covers Crossroads_API_Model_Serializer_Constant
 */
class Crossroads_API_Model_Serializer_ConstantTest extends TestCase {
    /**
     * @dataProvider serializeItemData
     */
    public function testSerializeItem($value) {
        $serializer = new Crossroads_API_Model_Serializer_Constant([
            "value" => $value,
        ]);

        $this->assertSame($value, $serializer->serializeItem(new stdClass));
    }

    public function serializeItemData() {
        $obj = new stdClass;

        return [
            [null, null],
            [0, 0],
            [$obj, $obj],
            [[], []],
            ["foo", "foo"],
        ];
    }
}
