<?php

class Crossroads_API_Model_Serializer_Product_Stockinfo extends Crossroads_API_Model_Serializer_Abstract {
    /**
     * Populates a stock-info structure with data from cataloginventory.
     *
     * @param  Mage_Catalog_Model_Product
     * @return ["stockQty" => int|null, "stockBackorders" => boolean|null, "stockManage" => boolean|null]
     */
    public function serializeItem($product) {
        $stock = Mage::getModel("cataloginventory/stock_item")->loadByProduct($product);

        $stockBackorders = (bool)$stock->getBackorders();
        $stockManage     = (bool)$stock->getManageStock();
        $stockQty        = $stockManage ? (double)$stock->getQty() : null;

        return [
            "stockQty"        => $stockQty,
            "stockBackorders" => $stockBackorders,
            "stockManage"     => $stockManage,
        ];
    }
}
