<?php

class Crossroads_API_Model_Category extends Mage_Core_Model_Abstract implements JsonSerializable {
    public function prepare($category, $collection) {
        $catData = new Varien_Object([
            "id"              => (int)$category->getEntityId(),
            "name"            => $category->getName(),
            "description"     => $category->getDescription(),
            "metaDescription" => $category->getMetaDescription(),
            "urlKey"          => $category->getUrlKey(),
            "url"             => $category->getUrlPath(),
            "position"        => (int)$category->getPosition(),
            "level"           => (int)$category->getLevel(),
            "isAnchor"        => $category->getIsAnchor() > 0,
            "path"            => $category->getPath(),
            "parentId"        => (int)$category->getParentId(),
            "metaTitle"       => $category->getMetaTitle(),
            "includeInMenu"   => $category->getIncludeInMenu() > 0,
            "productCount"    => $this->includeCount ? ($productCollection ? $productCollection->getSize() : $this->countCategoryProducts($category)) : null
        ]);

        Mage::dispatchEvent(self::EVENT_CATEGORY_POST_DATA_PREPARE, [
            "category"       => $category,
            "prepared_data"  => $catData,
            "include_images" => $includeImages
        ]);

        $this->data = $catData->getData();

        return $this;
    }
}
