<?php

declare(strict_types=1);

use PHPUnit\Framework\TestCase;

require_once("Mage.php");
require_once("Mage/Catalog/Model/Product.php");

require_once("Model/Serializer/Abstract.php");
require_once("Model/Serializer/Product/Abstract.php");
require_once("Model/Serializer/Product/Stockinfo.php");
require_once("Model/Serializer/Product/Stockinfo/Empty.php");

/**
 * @covers Crossroads_API_Model_Serializer_Product_Stockinfo_Empty
 */
class Crossroads_API_Model_Serializer_Product_Stockinfo_EmptyTest extends TestCase {
    public function testGetStockInfoFalse() {
        $product    = $this->getMockBuilder(Mage_Catalog_Model_Product::class)
                           ->setMethods([])
                           ->getMock();
        $serializer = new Crossroads_API_Model_Serializer_Product_Stockinfo_Empty();

        $this->assertSame([ "stockQty" => null, "stockBackorders" => null, "stockManage" => null], $serializer->serializeItem($product));
    }
}
