<?php

declare(strict_types=1);

use PHPUnit\Framework\TestCase;

require_once("Mage.php");
require_once("Varien/Object.php");

require_once("Model/Serializer/Abstract.php");
require_once("Model/Serializer/Image/Original.php");

/**
 * @covers Crossroads_API_Model_Serializer_Image_Original
 */
class Crossroads_API_Model_Serializer_Image_OriginalTest extends TestCase {
    /**
     * @dataProvider imageAttributes
     */
    public function testGetImageLink($type, $size, $resize) {
        $p = new stdClass;

        $imageMock = $this->getMockBuilder(stdClass::class)
                          ->setMethods(["init", "keepFrame", "resize", "__toString"])
                          ->getMock();
        $imageMock->expects($this->once())
                  ->method("init")
                  ->with($this->identicalTo($p), $this->equalTo($type))
                  ->will($this->returnSelf());
        $imageMock->expects($this->never())
                  ->method("keepFrame");
        $imageMock->expects($this->never())
                  ->method("resize");
        $imageMock->expects($this->once())
                  ->method("__toString")
                  ->will($this->returnValue("mocked_image_link"));

        Mage::_setHelper("catalog/image", $imageMock);

        $serializer = new Crossroads_API_Model_Serializer_Image_Original([
           "attr" => $type,
           "size" => $size,
           "fill" => $resize,
       ]);

        $this->assertEquals("mocked_image_link", $serializer->serializeItem($p));
    }

    public function imageAttributes() {
        $sizes = [
            [0,   false],
            [1,   false],
            [0,   true],
            [340, false],
            [340, true],
        ];

        return array_merge(
            array_map(function($c) { return [
                "small_image",
                $c[0],
                $c[1],
            ]; }, $sizes),
            array_map(function($c) { return [
                "image",
                $c[0],
                $c[1],
            ]; }, $sizes),
            array_map(function($c) { return [
                "thumbnail",
                $c[0],
                $c[1],
            ]; }, $sizes)
        );
    }
}
