<?php

class Mage_Core_Model_Store {
    protected $id        = 0;
    protected $websiteId = 0;
    protected $config    = [];

    public function __construct($config) {
        $this->id        = array_key_exists("id", $config)        ? $config["id"]        : 0;
        $this->config    = array_key_exists("config", $config)    ? $config["config"]    : [];
        $this->websiteId = array_key_exists("websiteId", $config) ? $config["websiteId"] : 0;
    }

    public function getId() {
        return $this->id;
    }

    public function getWebsiteId() {
        return $this->websiteId;
    }

    public function getConfig($key) {
        return array_key_exists($key, $this->config) ? $this->config[$key] : null;
    }
}
