<?php

/**
 * Model which converts model objects of type T to a JSON-encodable value U.
 */
abstract class Crossroads_API_Model_Serializer_Abstract {
    public function __construct(array $params = []) {
        // Intentionally left empty
    }

    /**
     * @param  Varien_Data_Collection<T>
     * @return Array<U>
     */
    public function mapCollection($collection) {
        return $this->mapArray($collection->getItems());
    }

    /**
     * @param  Array<T>
     * @return Array<U>
     */
    public function mapArray(array $array) {
        return array_values(array_map([$this, "serializeItem"], $array));
    }

    /**
     * @param  T
     * @return U
     */
    abstract public function serializeItem($item);
}
