<?php

class Crossroads_API_Model_Eav_Entity_Attribute_Source_Shippingmethod extends Mage_Eav_Model_Entity_Attribute_Source_Abstract {
    public function getAllOptions() {
        $customer = Mage::registry("current_customer");

        if( ! $customer) {
            $frontendSession = Mage::getSingleton("customer/session");
            $customer = $frontendSession->getCustomer();
        }

        $methods  = Mage::helper("API/shipping")->getAllShippingRatesForCustomer($customer);

        $values = array_values(array_map(function($p) {
            $code = sprintf("%s_%s", $p->getCarrier(), $p->getMethod());

            return [
                "label" => sprintf("%s (%s) - %s", $p->getCarrierTitle(), $code, $p->getMethodTitle()),
                "value" => $code,
            ];
        }, $methods));

        array_unshift($values, [
            "label" => "–",
            "value" => null,
        ]);

        return $values;
    }

    public function toOptionArray() {
        return $this->getAllOptions();
    }
}
