<?php

class Crossroads_API_Helper_Data extends Mage_Core_Helper_Abstract
{
    /**
     * Filters user text input, trims and removes non-breaking spaces.
     *
     * @param  mixed
     * @return mixed
     */
    public function filterInput($value) {
        if(is_string($value)) {
            // Replace non-breaking space and trim
            return trim(str_replace("\xc2\xa0", " ", $value));
        }
        else if(is_array($value)) {
            return array_map([$this, "filterInput"], $value);
        }

        return $value;
    }

    /**
     * Makes sure we have support for free payment in API.
     */
    public function registerPayment(Varien_Event_Observer $observer) {
        $observer->getRegistry()->addMethod(new Crossroads_API_Payment_Free());
        $observer->getRegistry()->addMethod(new Crossroads_API_Payment_Checkmo());
    }

    /**
     * This function adds additional attributes to the quote-item data, matching what
     * `Crossroads_API_Helper_Product::prepareCartProduct` adds to `attributes`.
     */
    public function addQuoteProductAttributes($event) {
        $store      = Mage::app()->getStore();
        $attributes = $event->getAttributes();

        $config = unserialize($store->getConfig(Crossroads_API_Model_Factory::CONFIG_CART_ATTRIBUTES));

        foreach (($config ?: []) as $attribute) {
            if(!is_array($attribute) ||
                !array_key_exists("attribute_code", $attribute)) {
                continue;
            }

            $code = $attribute["attribute_code"];

            // Magento looks in the list of keys on the Varien_Object
            $attributes->setData($code, "");
        }
    }
}